package cn.com.duiba.quanyi.center.api.dto.bill;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 账单表
 * @author mybatis generator 
 * @date 2024-02-26
 */
@Data
public class BillDto implements Serializable {
     
    private static final long serialVersionUID = 17089143496936938L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 账单业务类型 1-江西银商
     * {@link cn.com.duiba.quanyi.center.api.enums.bill.BillBizTypeEnum}
     */
    private Integer bizType;

    /**
     * 不同账单业务类型对应不同的业务id 需求id/活动id...
     */
    private Long bizId;

    /**
     * 商户账号
     */
    private String merchantAccount;

    /**
     * 推送时间
     */
    private Date pushTime;

    /**
     * 下载时间
     */
    private Date downloadTime;

    /**
     * 钉钉机器人accessToken
     */
    private String dingTalkToken;

    /**
     * 创建人id
     */
    private Long creatorId;

    /**
     * 创建人姓名
     */
    private String creatorName;

    /**
     * 逻辑删除标志 0-未删除 1-已删除
     */
    private Integer logicDeleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}