package cn.com.duiba.quanyi.center.api.param.bill;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 账单任务表
 * @author mybatis generator 
 * @date 2024-02-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class BillTaskSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17089149170765494L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 任务编号
     */
    private String taskNo;

    /**
     * 1-初始化 2-下载中 3-下载失败 4-下载成功 5-数据入库中 6-数据入库失败 7-数据入库完成 8-数据推送中 9-数据推送失败 10-数据推送完成 11-任务停止
     */
    private Byte taskStatus;

    /**
     * 预期推送时间
     */
    private Date expectedPushTime;

    /**
     * 推送时间
     */
    private Date pushTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}