package cn.com.duiba.quanyi.center.api.param.bill;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 账单任务明细
 * @author mybatis generator 
 * @date 2024-02-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class BillTaskDetailSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17091989073391343L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 任务id tb_bill_task.id
     */
    private Long billTaskId;

    /**
     * 批次id
     */
    private String stockId;

    /**
     * 起始时间
     */
    private LocalDate startDate;

    /**
     * 结束时间
     */
    private LocalDate endDate;

    /**
     * 商户号
     */
    private String mchId;

    /**
     * 下载状态 1-下载中 2-下载成功 3-下载失败
     */
    private Integer downloadStatus;

    /**
     * 账单原始文件oss地址
     */
    private String billOssUrl;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}