package cn.com.duiba.quanyi.center.api.dto.common;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 推广链接表
 *
 * @author kjj mybatis generator
 * @date 2023-09-19
 */
@Data
public class SpreadLinkDto implements Serializable {

    private static final long serialVersionUID = -5655035546244746500L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 渠道ID
     */
    private Long channelBizId;

    /**
     * 渠道类型, 1-商品包
     *
     * @see cn.com.duiba.quanyi.center.api.enums.ChannelBizTypeEnum
     */
    private Integer channelBizType;

    /**
     * 小程序appId
     */
    private String mpAppId;

    /**
     * 小程序跳转path
     */
    private String mpPagePath;

    /**
     * 参数短链key
     */
    private String queryShortKey;

    /**
     * 小程序码
     */
    private String mpQrCode;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 对外短链
     */
    private String outUrl;
}