package cn.com.duiba.quanyi.center.api.dto.pkg;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 商品包表
 * @author kjj mybatis generator 
 * @date 2023-09-14
 */
@Data
public class GoodsPkgDto implements Serializable {

    private static final long serialVersionUID = -129719524060021059L;
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 商品包名称
     */
    private String goodsPkgName;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 背景图片
     */
    private String backgroundImg;

    /**
     * 详情描述
     */
    private String detailDesc;

    /**
     * 详情图，多张图用英文逗号分割
     */
    private String detailImgs;

    /**
     * 是否启用, 0-停用, 1-启用
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer goodsPkgStatus;

    /**
     * 创建人操作Id,ssoid
     */
    private Long createOperatorId;

    /**
     * 创建人名称,ssoname
     */
    private String createOperatorName;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}