package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityWhiteListDto;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityWhiteListPageQueryParam;

import java.util.List;

/**
 * 活动白名单表
 *
 * @author lizhi
 * @date 2023/8/7 16:46
 */
@AdvancedFeignClient
public interface RemoteActivityWhiteListService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 活动白名单
     */
    ActivityWhiteListDto selectById(Long id);


    /**
     * 新增
     *
     * @param activityWhiteListDto 活动白名单
     * @return 执行结果
     */
    Long insert(ActivityWhiteListDto activityWhiteListDto);

    /**
     * 根据主键查询
     *
     * @param activityId 活动ID
     * @param userPhone  用户手机号
     * @return 活动白名单
     */
    ActivityWhiteListDto selectByActivityPhone(Long activityId, String userPhone);

    /**
     * 根据主键查询
     *
     * @param activityId 活动ID
     * @param userId     用户ID
     * @return 活动白名单
     */
    ActivityWhiteListDto selectByActivityUser(Long activityId, Long userId);

    /**
     * 绑定用户
     *
     * @param activityId 活动ID
     * @param userId     用户ID
     * @param userPhone  用户手机号
     * @return 执行结果
     */
    int bindUser(Long activityId, Long userId, String userPhone);


    /**
     * 删除
     *
     * @param id           主键
     * @param operatorType 操作人类型
     * @param operatorId   操作人id
     * @param operatorName 操作人名字
     * @return 执行结果
     */
    int delete(Long id, Integer operatorType, Long operatorId, String operatorName);

    /**
     * 筛选活动下的白名单，分页查询
     *
     * @param param
     * @return 活动白名单
     */
    List<ActivityWhiteListDto> selectPageByActivityId(ActivityWhiteListPageQueryParam param);

    /**
     * 筛选活动下的白名单，count
     *
     * @param activityId 活动id
     * @return 活动白名单
     */
    Integer countByActivityId(Long activityId);

    /**
     * 筛选客户经理添加的某个活动的白名单
     *
     * @param activityId   活动id
     * @param operatorType 操作人类型
     * @param operatorId   操作人id
     * @param lastId       分页序号
     * @param pageSize     分页大小
     * @return 活动白名单
     */
    List<ActivityWhiteListDto> selectPageByActivityIdAndOpId(Long activityId, Integer operatorType, Long operatorId, Long lastId, Integer pageSize);
}
