package cn.com.duiba.quanyi.center.api.dto.insurance.equity;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 保司权益表
 * @author mybatis generator 
 * @date 2024-03-04
 */
@Data
public class InsuranceEquityDto implements Serializable {
     
    private static final long serialVersionUID = 17095322687013054L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.center.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 保险公司ID，tb_insurance_company.id
     */
    private Long companyId;

    /**
     * 机构ID，tb_insurance_institution.id
     */
    private Long institutionId;

    /**
     * 坐席手机号
     */
    private String salesmanPhone;

    /**
     * 坐席姓名
     */
    private String salesmanName;

    /**
     * 兑换状态：1-为兑换，2-部分兑换，3-已兑换
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceEquityStatusEnum
     */
    private Integer takeStatus;

    /**
     * 总金额，单位分
     */
    private Long totalAmount;

    /**
     * 已发放金额，单位分
     */
    private Long grantAmount;

    /**
     * 已领取金额，单位分
     */
    private Long takeAmount;

    /**
     * 发放方式：1-一次性发放，2-分批发放
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceEquityGrantTypeEnum
     */
    private Integer grantType;

    /**
     * 领取方式：1-本人领取，2-授权代领
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceEquityTakeTypeEnum
     */
    private Integer takeType;

    /**
     * 代领人姓名
     */
    private String takeProxyName;

    /**
     * 代领人手机号
     */
    private String takeProxyPhone;

    /**
     * 第一批金额，单位分
     */
    private Long firstBatch;

    /**
     * 第二批金额，单位分
     */
    private Long secondBatch;

    /**
     * 文本备注
     */
    private String textRemark;

    /**
     * 图片备注，图片地址以英文逗号分隔
     */
    private String picRemark;

    /**
     * 审核状态：1-未审核，2-审核通过，3-审核不通过
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceEquityAuditStatusEnum
     */
    private Integer auditStatus;

    /**
     * 验真状态：1-未验真，2-验真通过，3-验真不通过
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceEquityVerifyStatusEnum
     */
    private Integer verifyStatus;

    /**
     * 实际发放账户手机号
     */
    private String accountPhone;
}