package cn.com.duiba.quanyi.center.api.log.operate;

import cn.com.duiba.quanyi.center.api.log.operate.log.OperateLogAop;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duibaboot.ext.autoconfigure.threadpool.policy.AbortPolicyWithReport;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author yangyukang
 */
@ComponentScan("cn.com.duiba")
@ConditionalOnWebApplication
@Order(-1)
public class LogAutoConfiguration implements WebMvcConfigurer {

    @Bean
    public OperateLogAop operateLogAop(){
        return new OperateLogAop();
    }

    @Bean
    public ExecutorService logExecutorService(){
        BlockingQueue<Runnable> queue = new ArrayBlockingQueue<>(500);
        return new ThreadPoolExecutor(10,40,
                60L, TimeUnit.SECONDS,
                queue,
                new NamedThreadFactory("sso"),
                new AbortPolicyWithReport());
    }


}
