package cn.com.duiba.quanyi.center.api.log.operate.log;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

import java.util.Objects;

/**
 * @author lizhi
 * @date 2023/11/14 14:49
 */
public class OperateLogger {
    
    private OperateLogger() {}

    /**
     * 由切面产生,如果没有此日志线程对象,则SsoLogger的无法打印日志
     */
    private static final ThreadLocal<OperateLoggerContext> THREAD_CONTEXT = new ThreadLocal<>();

    public static void appendJson(String operatorId, String operatorName, Long bizId, JSONObject extInfo) {
        OperateLoggerContext context = getOperateLoggerStackContext();
        if(context==null){
            return;
        }
        if(StringUtils.isBlank(operatorId)) {
            operatorId = StringUtils.EMPTY;
        }
        if(StringUtils.isBlank(operatorName)) {
            operatorName = StringUtils.EMPTY;
        }
        if(Objects.isNull(extInfo)) {
            extInfo = new JSONObject();
        }
        context.setOperatorId(operatorId);
        context.setOperatorName(operatorName);
        context.setBizId(bizId);
        context.setExtInfo(extInfo.toJSONString());
    }

    /**
     * 初始化 stackContext
     */
    protected static void init() {
        OperateLoggerContext context = THREAD_CONTEXT.get();
        if (Objects.isNull(context)) {
            context = new OperateLoggerContext();
            THREAD_CONTEXT.set(context);
        }
    }

    protected static OperateLoggerContext getOperateLoggerStackContext() {
        OperateLoggerContext context = THREAD_CONTEXT.get();
        if(Objects.isNull(context)){
            throw new UnsupportedOperationException("当前线程没有位于Sso操作日志切面中");
        }
        return context;
    }

    protected static void clearThreadLocal() {
        THREAD_CONTEXT.remove();
    }
}
