package cn.com.duiba.quanyi.center.api.remoteservice.insurance.equity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.equity.InsuranceEquityDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceEquitySearchParam;
import java.util.List;

/**
 * 保司权益表
 * @author kjj mybatis generator 
 * @date 2024-03-04
 */
@AdvancedFeignClient
public interface RemoteInsuranceEquityService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 保司权益集合
     */
    List<InsuranceEquityDto> selectPage(InsuranceEquitySearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceEquitySearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 保司权益
     */
    InsuranceEquityDto selectById(Long id);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}