package cn.com.duiba.quanyi.center.api.remoteservice.insurance.institution;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.company.InsuranceCompanyStatDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.institution.InsuranceInstitutionFundDto;

import java.util.List;

/**
 * 保司机构资金表
 * @author kjj mybatis generator 
 * @date 2024-03-04
 */
@AdvancedFeignClient
public interface RemoteInsuranceInstitutionFundService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 保司机构资金
     */
    InsuranceInstitutionFundDto selectById(Long id);



    /**
     * 根据机构ID查询
     * @param institutionId
     * @return 保司机构资金
     */
    InsuranceInstitutionFundDto selectByInstitutionId(Long institutionId);


    /**
     * 根据机构ID列表，查询统计数据
     * @param institutionIds
     * @return
     */
    List<InsuranceInstitutionFundDto> selectByInstitutionIds(List<Long> institutionIds);


    /**
     * 变更资金
     * @param institutionId 机构ID
     * @param changeType 变更类型，1-支出, 2-收入
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceFundChangeTypeEnum
     * @param changeAmount 变更金额，单位分
     * @return
     */
    boolean change(Long institutionId, Integer changeType, Long changeAmount);
}