package cn.com.duiba.quanyi.center.api.enums.insurance;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * @author lizhi
 * @date 2024/3/4 14:36
 */
@Getter
@AllArgsConstructor
public enum InsuranceEquityAuditStatusEnum {
    NOT_NEED(0, "无需审核"),
    NOT_AUDIT(1, "待审核"),
    PASS(2, "审核通过"),
    NO_PASS(3, "审核不通过"),
//    SELF_AUDIT_PASS(4, "自审通过")

    ;

    public static InsuranceEquityAuditStatusEnum getByStatus(Integer status){
        for (InsuranceEquityAuditStatusEnum audit : InsuranceEquityAuditStatusEnum.values()){
            if (Objects.equals(audit.getStatus(), status)){
                return audit;
            }
        }
        return null;
    }
    
    private final Integer status;
    
    private final String desc;
}
