package cn.com.duiba.quanyi.center.api.remoteservice.insurance.verify;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.insurance.verify.InsuranceVerifyPolicyUploadRecordDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceVerifyPolicyUploadRecordSearchParam;
import java.util.List;

/**
 * 保单验真上传记录表
 * @author kjj mybatis generator 
 * @date 2024-03-14
 */
@AdvancedFeignClient
public interface RemoteInsuranceVerifyPolicyUploadRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 保单验真上传记录集合
     */
    List<InsuranceVerifyPolicyUploadRecordDto> selectPage(InsuranceVerifyPolicyUploadRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceVerifyPolicyUploadRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 保单验真上传记录
     */
    InsuranceVerifyPolicyUploadRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 保单验真上传记录
     * @return 执行结果
     */
    int insert(InsuranceVerifyPolicyUploadRecordDto dto);

    /**
     * 更新
     * @param dto 保单验真上传记录
     * @return 影响行数
     */
    int update(InsuranceVerifyPolicyUploadRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 查询验真
     * @param id 最后一个id 第一个不用传
     * @param verifyStatus 验真状态
     * @param pageSize 分页大小
     * @return 执行结果
     */
    List<InsuranceVerifyPolicyUploadRecordDto> selectByOffset(Long id, Integer verifyStatus, Integer pageSize);
}