package cn.com.duiba.quanyi.center.api.remoteservice.security;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.security.CiticUserAssociationDto;
import cn.com.duiba.quanyi.center.api.param.qy.security.CiticUserAssociationSearchParam;
import java.util.List;

/**
 * 用户关联表
 * @author kjj mybatis generator 
 * @date 2024-03-12
 */
@AdvancedFeignClient
public interface RemoteCiticUserAssociationService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 用户关联集合
     */
    List<CiticUserAssociationDto> selectPage(CiticUserAssociationSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(CiticUserAssociationSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 用户关联
     */
    CiticUserAssociationDto selectById(Long id);

    /**
     * 新增
     * @param dto 用户关联
     * @return 执行结果
     */
    int insert(CiticUserAssociationDto dto);

    /**
     * 更新
     * @param dto 用户关联
     * @return 影响行数
     */
    int update(CiticUserAssociationDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}