package cn.com.duiba.quanyi.center.api.dto.goods;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 商品库下单表
 * @author kjj mybatis generator 
 * @date 2023-09-14
 */
@Data
public class GoodsOrderDto implements Serializable {

    private static final long serialVersionUID = -1822734768972037695L;
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 商品库订单业务主键
     */
    private Long goodsBizId;

    /**
     * 商品库订单业务类型, 1-白名单活动，2-商品包
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderBizTypeEnum
     */
    private Integer goodsBizType;

    /**
     * 业务单号
     */
    private String bizOrderNo;

    /**
     * 订单号
     */
    private String goodsOrderNo;

    /**
     * 规格ID
     */
    private Long skuId;

    /**
     * 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    private Integer spuType;
    
    /**
     * 订单价格，单位分
     */
    private Long orderPrice;

    /**
     * 商品数量
     */
    private Integer quantity;

    /**
     * 订单状态, 1-处理中，2-成功，3-失败, 4-异常
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderStatusEnum
     */
    private Integer orderStatus;

    /**
     * 领取时间
     */
    private Date receiveTime;

    /**
     * 商品库订单号
     */
    private String orderNo;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 发放的批次表主键
     * 如：tb_wx_coupon.id
     * tb_alipay_activity.id
     */
    private Long couponId;

    /**
     * 活动类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum
     */
    private Integer activityType;

    /**
     * 调用商品库发放参数
     */
    private String accountInfo;

    /**
     * 失败原因
     */
    private String errorMsg;

    /**
     * 展示给前端的错误码
     */
    private String failCode;

    /**
     * 链接券-短链
     */
    private String shortUrl;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 发放方式：1-直充，2-短链
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderGrantTypeEnum
     */
    private Integer grantType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}