package cn.com.duiba.quanyi.center.api.dto.goods;

import lombok.Data;

import java.io.Serializable;

/**
 * 商品库下单结果
 *
 * @author lizhi
 * @date 2023/8/18 16:16
 */
@Data
public class GoodsOrderResultDto implements Serializable {

    private static final long serialVersionUID = 2440785135308791075L;

    /**
     * 错误码
     */
    private String failCode;

    /**
     * 失败原因
     */
    private String errorMsg;

    /**
     * 成功时有值
     */
    private String goodsOrderNo;

    /**
     * 订单状态, 成功时有值
     *
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderStatusEnum#getStatus()
     */
    private Integer orderStatus;

    /**
     * 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    private Integer spuType;

    /**
     * 发放方式：1-直充，2-短链
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderGrantTypeEnum
     */
    private Integer grantType;

    /**
     * 链接券-短链
     */
    private String shortUrl;

    public GoodsOrderResultDto() {
    }

    public GoodsOrderResultDto(String failCode, String goodsOrderNo, Integer orderStatus, Integer spuType, Integer grantType, String shortUrl) {
        this.failCode = failCode;
        this.goodsOrderNo = goodsOrderNo;
        this.orderStatus = orderStatus;
        this.spuType = spuType;
        this.grantType = grantType;
        this.shortUrl = shortUrl;
    }

    public GoodsOrderResultDto(String failCode, String errorMsg, String goodsOrderNo, Integer orderStatus, Integer spuType, Integer grantType, String shortUrl) {
        this.failCode = failCode;
        this.errorMsg = errorMsg;
        this.goodsOrderNo = goodsOrderNo;
        this.orderStatus = orderStatus;
        this.spuType = spuType;
        this.grantType = grantType;
        this.shortUrl = shortUrl;
    }

    /**
     * 是否成功
     *
     * @return 是否成功
     */
    public boolean isSuccess() {
        return failCode == null || failCode.isEmpty();
    }
}
