package cn.com.duiba.quanyi.center.api.param.insurance;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * @author lizhi
 * @date 2024/3/4 15:08
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class InsuranceEquitySearchParam extends PageQuery {
    
    private static final long serialVersionUID = -2175986493715233817L;

    /**
     * 保险公司ID，tb_insurance_company.id
     */
    private Long companyId;

    /**
     * 机构ID，tb_insurance_institution.id
     */
    private Long institutionId;

    /**
     * ID列表，不为null且不为空则作为判断条件
     */
    private List<Long> ids;

    /**
     * 坐席登录账号ID
     */
    private Long salesmanId;

    /**
     * 坐席姓名
     */
    private String salesmanName;

    /**
     * 审核状态：1-未审核，2-审核通过，3-审核不通过
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceEquityAuditStatusEnum
     */
    private Integer auditStatus;

    /**
     * 验真状态：1-未验真，2-验真通过，3-验真不通过
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceEquityVerifyStatusEnum
     */
    private Integer verifyStatus;

    /**
     * 实际发放账户手机号
     */
    private String accountPhone;

    /**
     * 兑换状态：1-为兑换，2-部分兑换，3-已兑换
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceEquityStatusEnum
     */
    private Integer takeStatus;

    /**
     * 排序类型
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceEquitySortTypeEnum
     */
    private Integer sortType;
}
