package cn.com.duiba.quanyi.center.api.dto.insurance.company;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 保险公司
 * @author mybatis generator 
 * @date 2024-03-04
 */
@Data
public class InsuranceCompanyDto implements Serializable {
     
    private static final long serialVersionUID = 17095322686724810L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 公司状态：0-未上架，1-已上架，2-已下架
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceStatusEnum
     */
    private Integer companyStatus;

    /**
     * 费率审核阈值
     */
    private String rateThreshold;

    /**
     * 车险权益阈值
     */
    private Long carThreshold;

    /**
     * 非车权益阈值
     */
    private Long nonCarThreshold;

    /**
     * 是否审核验真，0-否，1-是
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer auditVerify;

    /**
     * 关联活动ID
     */
    private Long activityId;

    /**
     * 手机号
     */
    private String companyAdminPhone;

    /**
     * 姓名
     */
    private String companyAdminName;

    /**
     * 当前管理员ID
     */
    private Long companyAdminId;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 创建人id
     */
    private Long createOperatorId;

    /**
     * 创建人名称
     */
    private String createOperatorName;

    /**
     * 业务版本
     */
    private Integer bizVersion;
}