package cn.com.duiba.quanyi.center.api.param.activity;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class ActivityPageQueryParam extends PageQuery {

    private static final long serialVersionUID = 2963781322008217990L;
    /**
     * 活动状态
     */
    private Integer activityStatus;

    /**
     * 活动类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum
     */
    private Integer activityType;

    /**
     * 活动类型集合
     *
     * @see cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum
     */
    private List<Integer> activityTypes;

    /**
     * 活动ID
     */
    private Integer activityId;

    /**
     * 创建人sso id
     */
    private Long createOperatorId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 合同主键ID集合, tb_contract.id
     */
    private List<Long> contractIdList;


    /**
     * 需求id
     */
    private Long demandId;
}
