package cn.com.duiba.quanyi.center.api.param.channel;

import lombok.Data;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;

/**
 * @author lizhi
 * @date 2023/9/19 14:03
 */
@Data
public class MpUrlSchemeGenerateParam implements Serializable {
    
    private static final long serialVersionUID = 9060698253797421643L;

    /**
     * 业务类型
     * @see cn.com.duiba.quanyi.center.api.enums.user.OaBizTypeEnum
     */
    private Integer bizType;

    /**
     * 小程序页面地址
     */
    private String pagePath;

    /**
     * 小程序请求参数
     */
    private String query;

    /**
     * 是否为过期的地址
     * 默认为true
     */
    private Boolean isExpired = true;

    /**
     * 过期时间，isExpired为true时必填
     */
    private Integer timeUnitNumber;

    /**
     * 过期时间单位，isExpired为true时必填
     */
    private TimeUnit timeUnit;
}
