package cn.com.duiba.quanyi.center.api.param.insurance;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 权益保单验真记录表
 * @author mybatis generator 
 * @date 2024-03-14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class InsuranceVerifyPolicyRecordSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17103882269043494L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 车险保单号
     */
    private String carPolicyNo;

    /**
     * 非车保单号
     */
    private String nonCarPolicyNo;

    /**
     * 非车保费
     */
    private Long nonCarPolicyAmount;

    /**
     * 车险保费
     */
    private Long carPolicyAmount;

    /**
     * 公司ID
     */
    private Long companyId;

    /**
     * 匹配状态 0 未被匹配 1匹配成功
     */
    private Integer verifyStatus;

    /**
     * 上传记录id
     * @see cn.com.duiba.quanyi.center.api.dto.common.UploadTaskDto id
     */
    private Long uploadTaskId;
}