package cn.com.duiba.quanyi.center.api.remoteservice.api;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.api.ApiOrderResult;
import cn.com.duiba.quanyi.center.api.param.api.ApiCreateOrderParam;
import cn.com.duiba.quanyi.center.api.param.api.ApiOrderPageParam;
import cn.com.duiba.quanyi.center.api.param.api.ApiQueryOrderParam;

import java.util.List;

/**
 * API供货服务
 * @author lizhi
 * @date 2023/12/20 16:58
 */
@AdvancedFeignClient
public interface RemoteApiSupplyService {

    /**
     * 下单
     *
     * @param param 下单参数
     * @return 下单结果
     */
    ApiOrderResult createOrder(ApiCreateOrderParam param);

    /**
     * 查询订单
     *
     * @param param 查询参数
     * @return 查询结果
     */
    ApiOrderResult queryOrder(ApiQueryOrderParam param);

    /**
     * 分页查询订单
     * @param param - 查询参数
     * @return - 查询结果
     */
    List<ApiOrderResult> pageQueryOrder(ApiOrderPageParam param);
}
