package cn.com.duiba.quanyi.center.api.dto.bill;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * 账单任务明细
 * @author mybatis generator 
 * @date 2024-02-29
 */
@Data
public class BillTaskDetailDto implements Serializable {
     
    private static final long serialVersionUID = 17091989073389620L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 任务id tb_bill_task.id
     */
    private Long billTaskId;

    /**
     * 批次id
     */
    private String stockId;

    /**
     * 起始时间
     */
    private Date startDate;

    /**
     * 结束时间
     */
    private Date endDate;

    /**
     * 商户号
     */
    private String mchId;

    /**
     * 微信立减金类型 31-立减金 30-代金券
     */
    private String stockType;

    /**
     * 下载状态 1-下载中 2-下载成功 3-下载失败
     */
    private Integer downloadStatus;

    /**
     * 账单原始文件oss地址
     */
    private String billOssUrl;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    public String generateUniqueKey() {
        return StringUtils.join(mchId, stockId, startDate, endDate);
    }
}