package cn.com.duiba.quanyi.center.api.param.qy.bill.coupon;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 微信账单数据下载记录表
 * @author mybatis generator 
 * @date 2024-02-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class WxCouponBillDownloadRecordSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17090996442737588L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 活动Id
     */
    private Long activityId;

    /**
     * 微信批次号
     */
    private String stockId;

    /**
     * 微信批次号集合
     */
    private List<String> stockIdList;

    /**
     * 商户ID
     */
    private String mchId;

    /**
     * 账单类型 1:核销，2:退款
     */
    private Integer billType;

    /**
     * 处理状态 1:处理中 2:成功 3:失败
     */
    private Integer status;

    /**
     * 推送状态 1:未推送 2:已推送
     */
    private Integer pushStatus;

    /**
     * 额外信息
     */
    private String extra;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;
}