package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.AlipayActivityRelationDto;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 支付宝立减金活动关联
 *
 * @author zzy
 * @create 2023-09-22 21:11:03
 **/
@AdvancedFeignClient
public interface RemoteAlipayActivityRelationService {
    /**
     * 批量新增
     *
     * @param list 支付宝立减金活动关联
     * @return 执行结果
     */
    int batchInsert(List<AlipayActivityRelationDto> list);

    /**
     * 批量逻辑删除
     *
     * @param ids 主键集合
     * @return 执行结果
     */
    int batchDelete(List<Long> ids);

    /**
     * 根据活动奖项查询批次列表
     *
     * @param activityPrizeId
     * @return
     */
    Integer countByActivityPrizeIdAndActivityType(Long activityPrizeId, Integer activityType);

    /**
     * 根据活动奖项查询批次列表
     *
     * @param activityPrizeId
     * @return
     */
    List<AlipayActivityRelationDto> selectByActivityPrizeIdAndActivityType(Long activityPrizeId, Integer activityType);

    /**
     * 根据立减金ID批量查询
     *
     * @param alipayActivityIds 立减金ID集合
     * @return 支付宝立减金活动关联列表
     */
    List<AlipayActivityRelationDto> selectByAlipayActivityIds(Set<Long> alipayActivityIds);

    /**
     * 批量查询批次关联活动数量
     * @param couponIds 批次ID列表
     * @return key：批次ID，value：关联活动数量
     */
    Map<Long, Integer> selectActivityCountMapByCouponIds(Set<Long> couponIds);
}
