
package cn.com.duiba.quanyi.center.api.remoteservice.insurance.pay;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityPayResultDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.pay.WxNativeCreateOrderResultDto;
import cn.com.duiba.quanyi.center.api.dto.pay.WxMpCreateOrderResultDto;
import cn.com.duiba.quanyi.center.api.dto.pay.create.PayCreateOrderResultDto;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityPayCreateOrderParam;
import cn.com.duiba.quanyi.center.api.param.insurance.InsurancePayCreateOrderParam;

/**
 * 保司支付服务
 * @author lizhi
 * @date 2023/8/18 15:06
 */
@AdvancedFeignClient
public interface RemoteInsurancePayOrderService {

    /**
     * 创建订单
     * @param param 参数
     * @return 结果
     */
    WxNativeCreateOrderResultDto createOrder(InsurancePayCreateOrderParam param);

    /**
     * 创建订单
     * @param param 创建订单参数
     * @return 响应结果
     */
    PayCreateOrderResultDto createOrderNew(ActivityPayCreateOrderParam param);
    
    /**
     * 查询订单信息，若需要则异步触发查询支付平台
     * @param bizOrderNo 订单号
     * @return 订单信息
     */
    ActivityPayResultDto getAndSyncIfAbsent(String bizOrderNo);

    /**
     * 取消
     * @param bizOrderNo 订单号
     * @return 是否成功
     */
    boolean cancel(String bizOrderNo);
}
