package cn.com.duiba.quanyi.center.api.remoteservice.insurance.equity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.equity.InsuranceEquityHistoryDto;
import cn.com.duiba.quanyi.center.api.dto.qy.insurance.verify.InsuranceVerifyPolicyRecordDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceEquityHistorySearchParam;
import java.util.List;

/**
 * 历史保单表
 * @author kjj mybatis generator 
 * @date 2024-03-22
 */
@AdvancedFeignClient
public interface RemoteInsuranceEquityHistoryService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 历史保单集合
     */
    List<InsuranceEquityHistoryDto> selectPage(InsuranceEquityHistorySearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceEquityHistorySearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 历史保单
     */
    InsuranceEquityHistoryDto selectById(Long id);

    /**
     * 新增
     * @param dto 历史保单
     * @return 执行结果
     */
    int insert(InsuranceEquityHistoryDto dto);

    /**
     * 更新
     * @param dto 历史保单
     * @return 影响行数
     */
    int update(InsuranceEquityHistoryDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);


    /**
     * 批量新增
     * @param list 历史保单
     * @return 执行结果
     */
    int batchInsert(List<InsuranceEquityHistoryDto> list);

    /**
     * 根据唯一键批量查询
     * @param companyId 公司id
     * @param carPolicyNos 车险单号集合
     * @param nonCarPolicyNos 非车险单号集合
     * @return
     */
    List<InsuranceEquityHistoryDto> selectByUks(Long companyId, List<String> carPolicyNos, List<String> nonCarPolicyNos);

}