package cn.com.duiba.quanyi.center.api.param.ccbLife;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 结算补贴表
 * @author mybatis generator 
 * @date 2024-03-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class CcbSubsidySearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17095539449207261L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 开始时间
     */
    private Date gmtBegin;

    /**
     * 结束时间
     */
    private Date gmtEnd;

    /**
     * 商户号
     */
    private String businessNum;

    /**
     * 门店号
     */
    private String shopNum;

    /**
     * 商户名
     */
    private String businessName;

    /**
     * 门店名
     */
    private String shopName;

    /**
     * 分行名称
     */
    private String branchName;

    /**
     * 分行联系人
     */
    private String branchContactPerson;

    /**
     * 归属支行
     */
    private String homeBranch;

    /**
     * 账户名称
     */
    private String accountName;

    /**
     * 账户
     */
    private String accountNumber;

    /**
     * 开户行
     */
    private String bankName;

    /**
     * 补贴金额
     */
    private Long subsidyAmount;

    /**
     * 备注
     */
    private String remark;

    /**
     * 结算状态 0待确认 1已确认  2已结算
     */
    private Byte status;

    /**
     * 删除标识 （0：未删除，1：删除）默认为0
     */
    private Byte deleted;

    /**
     * 用户确认请求的json信息
     */
    private String userAgent;

    /**
     * 确认用户id
     */
    private String confirmUser;

    /**
     * 确认时间
     */
    private Date confirmTime;
    /**
     * 商户号集合
     */
    private List<String> businessNumList;
}