package cn.com.duiba.quanyi.center.api.dto.goods.ext;

import lombok.Data;

import java.io.Serializable;

/**
 * 微信领取
 *
 * @author zzy
 * @date 2023/10/17 16:08
 **/
@Data
public class BatchTakeParamDto implements Serializable {
    private static final long serialVersionUID = 1659564371405687186L;
    
    /**
     * 批量订单查询单号
     */
    private String batchQueryOrderNo;

    /**
     * 校验的key
     */
    private String key;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 微信公众号、小程序AppID
     */
    private String wxAppId;

    /**
     * 微信用户openId
     */
    private String wxOpenId;

    /**
     * 支付宝用户id，可通过支付宝授权方式获取
     */
    private String alipayUserId;

    /**
     * 支付宝openId, 映射支付宝user_id
     * 请使用open_id，后续user_id将不支持新接入使用，存量已对接的也将逐步回收。
     */
    private String alipayOpenId;

    /**
     * 支付宝登录账号，邮箱格式
     */
    private String alipayLoginId;

    /**
     * 支付宝登录账号，手机号格式
     */
    private String alipayPhoneId;
}
