package cn.com.duiba.quanyi.center.api.utils.wxcoupon;

import cn.com.duiba.wolf.utils.DateUtils;

/**
 * @author xuzhigang
 * @date 2024/4/8 14:33
 **/
public class WxCouponAutoCreateUtils {
    /**
     * 根据活动预算计算实际金额 公式：活动预算/活动周期 * 14（创建时预留2周的预算），且金额必须是面额的整数倍
     * @param budgetAmount 活动总预算
     * @param couponAmount 面额
     * @param startDate 活动开始时间
     * @param endDate 活动结束时间
     * @param stockDistributePeriod 实际活动周期
     * @return 实际金额（分）
     */
    public static Long calTotalAmount(Long budgetAmount, Long couponAmount, String startDate, String endDate, Integer stockDistributePeriod) {
        // 计算当前2周需要消耗的金额
        long twoWeeksAmount = (budgetAmount / calDiffDays(startDate, endDate, stockDistributePeriod)) * 14;
        // 加款金额必须是面额的整数倍 取余向上取整
        twoWeeksAmount = twoWeeksAmount + (couponAmount - (twoWeeksAmount % couponAmount));
        // 分转换为元 如果两周预算大于总预算 则直接设置为总预算
        return Math.min(budgetAmount, twoWeeksAmount);
    }

    public static Integer calMaxNum(Long budgetAmount, Long couponAmount, String startDate, String endDate, Integer stockDistributePeriod) {
        Long totalAmount = calTotalAmount(budgetAmount, couponAmount, startDate, endDate, stockDistributePeriod);
        return Math.toIntExact(totalAmount.intValue() / couponAmount);
    }

    private static Integer calDiffDays(String startDate, String endDate, Integer stockDistributePeriod) {
        if (stockDistributePeriod != null) {
            return stockDistributePeriod;
        }
        return DateUtils.daysBetween(DateUtils.getDayDate(startDate), DateUtils.getDayDate(endDate)) + 1;
    }
}
