package cn.com.duiba.quanyi.center.api.param.qy.signing;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 签约信息表
 * @author mybatis generator 
 * @date 2024-05-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class SigningSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17152576374834633L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 签约类型，0:微信 1:银行卡
     */
    private Byte signingType;

    /**
     * 用户姓名
     */
    private String userName;

    /**
     * 身份证号
     */
    private String userIdentificationCard;

    /**
     * 银行卡号
     */
    private String userBankCard;

    /**
     * 签约状态 0处理中 1成功 2失败
     */
    private Byte signingStatus;
}