package cn.com.duiba.quanyi.center.api.remoteservice.icbc;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.icbc.IcbcUserDto;

import java.util.List;

/**
 * 工行用户信息表
 * @author kjj mybatis generator 
 * @date 2024-02-04
 */
@AdvancedFeignClient
public interface RemoteIcbcUserService {

    /**
     * 新增
     * @param dto 工行用户信息
     * @return 执行结果
     */
    Long insert(IcbcUserDto dto);

    /**
     * 更新
     * @param dto 工行用户信息
     * @return 影响行数
     */
    int update(IcbcUserDto dto);

    /**
     * 根据用户唯一标识查询
     * @param custId
     * @return
     */
    IcbcUserDto selectByCustId(String custId);

    /**
     * 根据用户id查询
     * @param userId 用户ID
     * @return 用户
     */
    IcbcUserDto selectByUserId(Long userId);

    /**
     * 根据手机号查询
     * @param phone 手机号
     * @return 用户
     */
    List<IcbcUserDto> selectByPhone(String phone);
}