package cn.com.duiba.quanyi.center.api.remoteservice.qy.contract;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.contract.ContractSsoUserDto;
import cn.com.duiba.quanyi.center.api.param.qy.contract.ContractSsoUserSearchParam;
import java.util.List;

/**
 * 聚宝盆合同关联用户表
 * @author kjj mybatis generator 
 * @date 2024-06-04
 */
@AdvancedFeignClient
public interface RemoteContractSsoUserService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 聚宝盆合同关联用户集合
     */
    List<ContractSsoUserDto> selectPage(ContractSsoUserSearchParam param);

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param ssoId 查询条件
     * @return 聚宝盆合同关联用户集合
     */
    List<ContractSsoUserDto> selectBySsoId(Long ssoId);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ContractSsoUserSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 聚宝盆合同关联用户
     */
    ContractSsoUserDto selectById(Long id);

    /**
     * 新增
     * @param dto 聚宝盆合同关联用户
     * @return 执行结果
     */
    int insert(ContractSsoUserDto dto);

    /**
     * 更新
     * @param dto 聚宝盆合同关联用户
     * @return 影响行数
     */
    int update(ContractSsoUserDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 批量绑定运营信息
     * @param paramList
     * @return
     */
    int addOrUpdate(List<ContractSsoUserSearchParam> paramList);

    /**
     * 根据合同ID  批量查询
     * @param contractId 合同ID
     * @return
     */
    List<ContractSsoUserDto> selectByContractId(Long contractId);

}