package cn.com.duiba.quanyi.center.api.dto.api;

import cn.com.duiba.quanyi.center.api.enums.signing.SigningStatusEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * API-商品信息
 * @author lizhi
 * @date 2023/12/4 20:31
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class ApiQuerySigningResult extends ApiBaseResult {
    
    private static final long serialVersionUID = 4372430151952159865L;


    /**
     * 用户姓名
     * 同一个用户只用签约一次 ，用户姓名+身份证号算是同一个用户，
     * 如果签约状态为成功，同一用户其他信息再次传递，不会修改
     * 如果签约状态为失败，同一用户再次传递，会修改手机号，银行卡号、微信openId等信息
     */
    private String name;

    /**
     * 用户身份证号
     */
    private String idCard;

    /**
     * 用户手机号
     */
    private String phone;

    /**
     * 银行卡号（如果是银行大额转账必填）
     */
    private String bankCard;

    /**
     * 微信openId（如果是微信大额转账必填）
     */
    private String openId;

    /**
     * 签约状态
     * @see SigningStatusEnum
     */
    private Integer status;
}
