package cn.com.duiba.quanyi.center.api.remoteservice.demand;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.demand.DemandGoodsDto;

import java.util.List;

/**
 * 需求商品表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteDemandGoodsService {

    /**
     * 根据需求商品表id查询需求商品详情
     *
     * @param id 需求商品表id
     * @return 需求商品详情
     */
    DemandGoodsDto getDemandGoodsInfo(Long id);

    /**
     * 根据采购单id查询需求商品详情
     *
     * @param demandId 采购单id
     * @return 需求商品详情
     */
    List<DemandGoodsDto> getDemandGoodsListByDemandId(Long demandId);

    /**
     * 根据需求商品表id更新需求商品
     *
     * @param demandGoodsDto 需求商品信息
     * @return 操作条数
     */
    int updateDemandGoodsById(DemandGoodsDto demandGoodsDto);

    /**
     * 新增需求商品信息
     *
     * @param demandGoodsDto 需求商品信息
     * @return 操作条数
     */
    Long insertDemandGoods(DemandGoodsDto demandGoodsDto);

    /**
     * 根据需求商品单id删除需求商品
     *
     * @param id 需求商品单id
     * @return 操作条数
     */
    int deleteDemandGoods(Long id);

}