package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 业务活动类型
 * 对应于领取记录表的类型
 *
 * @author zzy
 * @create 2023/10/11 11:32
 **/
@Getter
@AllArgsConstructor
public enum BizActTypeEnum {
    BAI_MING_DAN(1, "白名单领奖"),
    
    DUIBA_KAMI(2, "兑吧卡密包"),

    CCB_ZJ_PAY(3, "浙江建行支付"),

    CCB_ZJ_DING_TALK_NEW(4, "浙江建行-钉钉联合营销-新户"),

    CCB_ZJ_DING_TALK_OLD(5, "浙江建行-钉钉联合营销-老户"),

    GOODS_PKG(6, "权益卡券包"),

    API_SUPPLY(7, "API供货"),

    ICBC_JX(8, "江西权益领奖"),

    CCB_ZJ_ALIPAY_RED_ENVELOPE_COVER(9, "浙江建行-支付宝红包封面"),
    ICBC_GD_SPRING_FESTIVAL(10, "广东工行春节活动"),

    INSURANCE(11, "保司关联活动"),
    ICBC_SHAANXI(12, "陕西工行活动"),
    ICBC_XINJIANG(13, "新疆工行活动"),
    TEMPLATE_PROBABILITY(15, "模版活动-概率出奖"),
    TEMPLATE_DIRECT(16, "模版活动-直接出奖"),

    CCB_SICHUAN_HUIMEI(14,"建行四川分行惠美活动"),


    ALI_TRAVEL_ACTIVITY(17,"支付宝旅行活动")
    ;

    public static String getDescByType(Integer type) {
        for (BizActTypeEnum typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum.getDesc();
            }
        }
        return null;
    }

    private final Integer type;

    private final String desc;
}
