package cn.com.duiba.quanyi.center.api.enums.api;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * API主订单状态
 * 
 * @author lizhi
 * @date 2023/12/21 16:06
 */
@Getter
@AllArgsConstructor
public enum ApiMainOrderStatusEnum {
    PROCESS(1, "处理中"),
    ALL_SUCCESS(2, "全部成功"),
    ALL_FAIL(3, "全部失败"),
    ALL_GRANT(4, "全部已发放"),
    ;
    
    private final Integer status;
    
    private final String desc;

    private static final Map<Integer, ApiMainOrderStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ApiMainOrderStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     * @param status 枚举值
     * @return 枚举
     */
    public static ApiMainOrderStatusEnum getByStatus(Integer status) {
        //默认返回处理中
        if (status == null) {
            return PROCESS;
        }
        return ENUM_MAP.get(status);
    }

}
