package cn.com.duiba.quanyi.center.api.param.api;

import lombok.Data;

import java.io.Serializable;

/**
 * API签约
 * @author cxw
 * @date 2024/05/28 10:11
 */
@Data
public class ApiQuerySigningParam implements Serializable {

    private static final long serialVersionUID = -4402952009826854906L;
    /**
     * 用户姓名
     * 同一个用户只用签约一次 ，用户姓名+身份证号算是同一个用户，
     * 如果签约状态为成功，同一用户其他信息再次传递，不会修改
     * 如果签约状态为失败，同一用户再次传递，会修改手机号，银行卡号、微信openId等信息
     */
    private String name;

    /**
     * 用户身份证号
     */
    private String idCard;

}
