package cn.com.duiba.quanyi.center.api.param.coupon;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;
import java.util.List;

/**
 * @author lizhi
 * @date 2023/8/21 14:24
 */
@ToString
@EqualsAndHashCode(callSuper = true)
@Data
public class WxCouponPageParam extends PageQuery {

    private static final long serialVersionUID = -5461048170996409136L;

    /**
     * 商户号
     */
    private String mchId;

    /**
     * 微信批次号
     */
    private String stockId;

    /**
     * 创建人操作Id,ssoid
     */
    private Long createOperatorId;

    /**
     * 创建人姓名
     */
    private String createOperatorName;

    /**
     * 需求商品主键, tb_demand_goods.id
     */
    private List<Long> demandGoodsIds;

    /**
     * 面额，单位分
     */
    private Long couponAmount;

    /**
     * 批次类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.WxStockTypeEnum
     */
    private List<Integer> stockTypes;

    /**
     * 业务状态
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.WxStockBizStatusEnum
     */
    private Integer bizStatus;

    /**
     * 批次状态
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.WxStockStatusEnum
     */
    private String stockStatus;

    /**
     * 活动名称
     */
    private String stockName;


    /**
     * 批次类型
     */
    private String stockType;

    /**
     * 面额类型：1-固定，2-不固定
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AmountTypeEnum#getType()
     */
    private Integer amountType;

    /**
     * 可用结束时间-开始查询范围时间
     */
    private Date availableEndTimeQueryStartTime;

    /**
     * 可用结束时间-结束查询范围时间
     */
    private Date availableEndTimeQueryEndTime;
}
