package cn.com.duiba.quanyi.center.api.remoteservice.activity;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityPrizeStockDto;

import java.util.Map;
import java.util.Set;

/**
 * 活动奖品库存表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */

@AdvancedFeignClient
public interface RemoteActivityPrizeStockService {

    /**
     * 根据活动奖项id查询库存
     *
     * @param activityPrizeId
     * @return
     */
    ActivityPrizeStockDto selectByActivityPrizeId(Long activityPrizeId);

    /**
     * 根据活动奖项id批量查询
     *
     * @param activityPrizeIds
     * @return
     */
    Map<Long, ActivityPrizeStockDto> selectListByActivityPrizeIds(Set<Long> activityPrizeIds);

    /**
     * 新增
     *
     * @param dto 活动奖品库存
     * @return 执行结果
     */
    Long insert(ActivityPrizeStockDto dto);

    /**
     * 更新库存
     *
     * @param id       id
     * @param totalNum 总库存
     * @return 执行结果
     */
    int updateTotalNum(Long id, Long totalNum);
}