package cn.com.duiba.quanyi.center.api.enums.bill;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * WxDownloadRecordStatusEnum
 *
 * @author fmk
 * @date 2024/3/6 14:03
 **/
@Getter
@AllArgsConstructor
public enum WxDownloadRecordStatusEnum {

    DOWNLOADING(1, "下载中"),

    DOWNLOAD_SUCCESS(2, "下载成功"),

    DOWNLOAD_FAIL(3, "下载失败"),

    UPLOADING_OSS(4, "上传OSS中"),

    UPLOAD_OSS_SUCCESS(5, "已上传oss"),

    UPLOAD_OSS_FAIL(6, "上传oss失败"),

    PUSH_SUCCESS(7, "推送完成")
    ;

    private int status;

    private String desc;

    public static boolean canUpload(int status) {
        return status == DOWNLOAD_SUCCESS.status || status == UPLOAD_OSS_SUCCESS.status;
    }
}
