package cn.com.duiba.quanyi.center.api.param.insurance;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 追加权益记录表
 * @author mybatis generator 
 * @date 2024-05-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class InsuranceAdditionalEquityRecordSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17163729373406132L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 权益ID
     */
    private Long insuranceEquityId;

    /**
     * 追加金额
     */
    private Long addAmount;

    /**
     * 0:未审核 1：审核通过 2审核拒绝
     */
    private Integer auditStatus;

    /**
     * 追加备注
     */
    private String addRemark;

    /**
     * 操作用户ID
     */
    private Long operatorId;

    /**
     * 操作人
     */
    private String operatorName;


    /**
     * ID列表，不为null且不为空则作为判断条件
     */
    private List<Long> equityIds;


    /**
     * 排序类型
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceEquitySortTypeEnum
     */
    private Integer sortType;

}