package cn.com.duiba.quanyi.center.api.remoteservice.contract;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.contract.ContractGoodsDto;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 合同商品表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteContractGoodsService {
    /**
     * 根据id查询合同商品
     *
     * @param id 主键
     * @return
     */
    ContractGoodsDto findById(Long id);

    /**
     * 根据id list批量查询合同商品
     *
     * @param ids 主键
     * @return key：主键，value：合同商品
     */
    Map<Long, ContractGoodsDto> findMapByIds(Set<Long> ids);

    /**
     * 新增
     *
     * @param dto
     * @return
     */
    Long insert(ContractGoodsDto dto);

    /**
     * 更新
     *
     * @param dto 合同商品
     * @return 执行结果
     */
    int update(ContractGoodsDto dto);

    /**
     * 查询合同下的商品列表
     *
     * @param contractId 合同id
     * @return
     */
    List<ContractGoodsDto> findContractGoods(Long contractId);

    /**
     * 根据合同id 商品id 查询合同下的商品
     * @param contractId 合同id
     * @param spuId 商品id
     * @return 合同商品
     */
    ContractGoodsDto findContractGoodsByContractIdAndSpuId(Long contractId, Long spuId);

}