package cn.com.duiba.quanyi.center.api.param.coupon;

import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author xuzhigang
 * @date 2024/3/19 20:55
 **/
@Data
public class WxCouponAddMoneyResultNotifyParam implements Serializable {
    private static final long serialVersionUID = -6865501808297257005L;

    /**
     * 商户号
     */
    @NotBlank(message = "商户号不能为空")
    private String mchCode;

    /**
     * 任务id
     */
    @NotNull(message = "任务id不能为空")
    private Long taskId;

    /**
     * 批次列表
     */
    @Valid
    @NotNull(message = "batchList不能空")
    private List<WxCouponAddMoneyStockParam> batchList;
}
