package cn.com.duiba.quanyi.center.api.dto.pay;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 支付订单表
 * @author kjj mybatis generator 
 * @date 2023-09-14
 */
@Data
public class PayOrderDto implements Serializable {

    private static final long serialVersionUID = -4514172986373830223L;
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 订单业务主键
     */
    private Long payBizId;

    /**
     * 订单业务类型, 1-白名单活动，2-商品包
     * @see cn.com.duiba.quanyi.center.api.enums.pay.PayBizTypeEnum
     */
    private Integer payBizType;

    /**
     * 员工用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 支付金额，单位分
     */
    private Long payAmount;

    /**
     * 支付渠道的appId
     */
    private String appId;

    /**
     * 订单号
     */
    private String bizOrderNo;

    /**
     * 支付状态 0-订单生成，1-收单成功, 2-收单失败, 3-支付失败, 4-支付成功 5-取消支付 6-退款中 7-退款成功 8-退款失败
     * @see cn.com.duiba.quanyi.center.api.enums.pay.PayStatusEnum
     */
    private Integer payStatus;

    /**
     * 支付过期时间
     */
    private Date expireTime;

    /**
     * 支付订单号(商户订单号)
     */
    private String outTradeNo;

    /**
     * 渠道返回的交易流水号
     */
    private String transactionNo;

    /**
     * 支付银行
     */
    private String bankType;

    /**
     * 支付时间
     */
    private Date paidTime;

    /**
     * 渠道支付失败码
     */
    private String failureCode;

    /**
     * 渠道支付失败描述
     */
    private String failureMsg;

    /**
     * 状态流转过程中的备注
     */
    private String remark;

    /**
     * 支付渠道类型
     * @see cn.com.duiba.quanyi.center.api.enums.pay.PayChannelTypeEnum
     */
    private String payChannelType;

    /**
     * 扩展信息json
     */
    private String extJson;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
    /**
     * 活动ID
     */
    private Long activityId;
    /**
     * 活动type
     */
    private Integer activityType;
}