package cn.com.duiba.quanyi.center.api.dto.statistic;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.quanyi.center.api.enums.alipay.AlipayActivityBizStatusEnum;
import lombok.Data;

/**
 * 支付宝活动数据统计表
 * @author mybatis generator 
 * @date 2024-07-02
 */
@Data
public class AlipayActivityStatisticDto implements Serializable {
     
    private static final long serialVersionUID = 17199025991626943L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 支付宝分配给开发者的应用ID
     */
    private String alipayAppId;

    /**
     * 支付宝活动后台类型，1-银行卡支付立减;2-通用渠道红包;3-首绑有礼;4-多刷有礼
     * {@link cn.com.duiba.quanyi.center.api.enums.coupon.AlipayActivityTypeEnum}
     */
    private Integer alipayActType;

    /**
     * 支付宝活动ID
     */
    private String alipayActId;

    /**
     * 支付宝活动创建时间 格式：yyyy-MM-dd
     */
    private Date alipayActTime;

    /**
     * 券模板ID
     */
    private String couponTemplateId;

    /**
     * 归属银行
     */
    private String belongBankName;

    /**
     * 业务状态：1-未同步，2-已同步
     * {@link AlipayActivityBizStatusEnum}
     */
    private Integer bizStatus;

    /**
     * 额外信息
     */
    private String extra;
}