package cn.com.duiba.quanyi.center.api.enums.bigdata;

import java.util.HashMap;
import java.util.Map;

/**
 * @author chenyongkun
 */

public enum BigdataHologresTableEnum {

    WX_STOCK_BILL_RUN_DETAIL(" stock_id as \"批次ID\",coupon_id as \"优惠id\",coupon_type as \"优惠类型\",discount_amount as \"优惠金额\",total_amount as \"订单总金额\",transaction_type as \"交易类型\",pay_order_num as \"支付单号\",to_char(consume_time, 'YYYY-MM-DD HH24:MI:SS') as \"消耗时间\",consume_mch_id as \"消耗商户号\",device_id as \"设备号\",bank_serial_num as \"银行流水号\",consume_code_wx as \"消耗门店编码(微信支付)\",consume_code_wx as \"消耗门店编码(商家自有)\" ", "quan_yi.tb_wx_stock_bill_run_detail", "微信进行中账单表"),

    WX_STOCK_BILL_STOPED_DETAIL(" stock_id as \"批次ID\",coupon_id as \"优惠id\",coupon_type as \"优惠类型\",discount_amount as \"优惠金额\",total_amount as \"订单总金额\",transaction_type as \"交易类型\",concat('`',pay_order_num) as \"支付单号\",to_char(consume_time, 'YYYY-MM-DD HH24:MI:SS') as \"消耗时间\",consume_mch_id as \"消耗商户号\",device_id as \"设备号\",concat('`',bank_serial_num) as \"银行流水号\",coupon_detail as \"单品信息\" ", "quan_yi.tb_wx_stock_bill_stoped_detail", "微信已结束账单表"),
    ;

    /**
     * 去
     */
    private final String sqlSegment;

    //是否需要传值
    private final String tableName;

    //解释说明
    private final String desc;

    //枚举集合
    private static final Map<String, BigdataHologresTableEnum> enumMap = new HashMap<>();

    BigdataHologresTableEnum(String sqlSegment, String tableName, String desc) {
        this.sqlSegment = sqlSegment;
        this.tableName = tableName;
        this.desc = desc;
    }

    public String getSqlSegment() {
        return sqlSegment;
    }

    public String getTableName() {
        return tableName;
    }

    public String getDesc() {
        return desc;
    }

    public static Map<String, BigdataHologresTableEnum> getEnumMap() {
        return enumMap;
    }

    static {
        BigdataHologresTableEnum[] values = BigdataHologresTableEnum.values();
        for (BigdataHologresTableEnum value : values) {
            enumMap.put(value.toString(), value);
        }
    }

}
