package cn.com.duiba.quanyi.center.api.param.coupon;

import cn.com.duiba.quanyi.center.api.enums.alipay.AlipayActivityBizStatusEnum;
import cn.com.duiba.quanyi.center.api.enums.coupon.AlipayActivityTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2023/8/21 14:35
 */
@Data
public class AlipayCouponAllocationParam implements Serializable {
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 创建人sso id
     */
    private Long createOperatorId;

    /**
     * 创建人
     */
    private String createOperatorName;

    /**
     * 支付宝活动后台类型
     * @see AlipayActivityTypeEnum
     */
    private Integer alipayActType;

    /**
     * 所属银行名称（可为空）
     */
    private String belongBankName;

    /**
     * 银行卡片类型（可为空）
     * @see cn.com.duiba.quanyi.center.api.enums.pay.BankCardTypeEnum;
     */
    private String bankCardType;

    /**
     * 面额类型：1-固定，2-不固定
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AmountTypeEnum#getType()
     */
    private Integer amountType;

    /**
     * 业务状态：1-待分配, 2-已分配
     * {@link AlipayActivityBizStatusEnum}
     */
    private Integer bizStatus;

}
