package cn.com.duiba.quanyi.center.api.remoteservice.statistic;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.statistic.AlipayActivityStatisticDto;
import cn.com.duiba.quanyi.center.api.param.statistic.AlipayActivityStatisticSearchParam;
import java.util.List;

/**
 * 支付宝活动数据统计表
 * @author kjj mybatis generator 
 * @date 2024-07-02
 */
@AdvancedFeignClient
public interface RemoteAlipayActivityStatisticService {
     
    /**
     * 根据条件查询
     * @param param 查询条件
     * @return 支付宝活动数据统计集合
     */
    List<AlipayActivityStatisticDto> selectParam(AlipayActivityStatisticSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(AlipayActivityStatisticSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 支付宝活动数据统计
     */
    AlipayActivityStatisticDto selectById(Long id);

    /**
     * 新增
     * @param dto 支付宝活动数据统计
     * @return 执行结果
     */
    int insert(AlipayActivityStatisticDto dto);

    /**
     * 更新
     * @param dto 支付宝活动数据统计
     * @return 影响行数
     */
    int update(AlipayActivityStatisticDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}