package cn.com.duiba.quanyi.center.api.param.activity;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 秒杀活动场次配置表
 * @author mybatis generator 
 * @date 2024-07-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class SeckillActivitySiteCountConfigSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17205817363124913L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Byte logicDelete;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 场次类型 0单场次 1多场次
     */
    private Byte siteCountType;

    /**
     * 循环维度 0 按天 1 按周 2 按月
     */
    private Byte circulateType;

    /**
     * 周限制时间，格式为 1,2,3,4 1表示周一，7表示周日
     */
    private String weekLimitByDay;

    /**
     * 月限制配置-开始时间
     */
    private Byte monthStartTime;

    /**
     * 月限制配置-结束时间
     */
    private Byte monthEndTime;
}